# 技术选型实战指南

> 选对技术，事半功倍



大家好，我是鱼皮。本篇要分享的内容是 **技术选型**，是技术方向的朋友们必须要掌握的内容，也是做产品时在前期准备阶段必须要做的核心工作。

这篇文章中，我会结合自己做产品的实践经验，依次给大家分享：什么是技术选型？技术选型选什么？为什么要做技术选型？如何做好技术选型？

无论你是用 Vibe Coding 做个人项目，还是想做一款真正的产品，掌握技术选型的方法都能让你少走很多弯路。



## 一、什么是技术选型？

技术选型这个词听起来很高大上，但其实就是 “技术选择”，即选择使用哪些技术来实现项目。比如使用 HTML 来开发网页、使用 C++ 来开发 Windows 桌面应用。

打个比方，如果把做项目想象成带兵打仗，技术选型就相当于打仗前选择武器。你要根据自身的兵种、敌人的种族、敌军的排兵布阵等来综合选择最适合的武器，才能以最小的代价胜利。

需要注意的是，技术选型不仅仅是在项目初期的规划和设计阶段进行。每当我们给项目增加一个新功能时，都有可能要选择新的技术来实现；而随着你项目的扩展，可能也需要对原有的技术栈进行升级。



## 二、技术选型选什么？

“用哪些技术来实现项目”，这句话听起来很简单。就像上面说的，用 HTML 来开发网页，一个技术名词就带过了。

但事实上，这只是最浅显的一层。做技术选型并不是一件轻松的事，又分为很多层次和细节。

由浅入深来看，技术选型包括：

1）选哪类技术？

比如编程语言、开发框架、数据存储、缓存、队列等。

2）具体选什么技术？

比如编程语言选 Java、Go 还是 C++？开发框架选 Spring 还是 Play？缓存选 Redis 还是 Memcached？

3）技术具体选哪个版本？

比如选 Java 8 还是 11？选 Vue 2 还是 Vue 3？选 Redis 5 还是 6？同一个技术的不同版本，往往也会有很大的差异。

4）选用技术的哪些具体特性？

比如 Spring 的 AOP 切面、Redis 的 GEO 高级数据结构等。



这么看来，技术选型还是有点儿麻烦的。而且一般来说，规模越大的项目，技术选型往往越谨慎，周期也就越长。

记得我在腾讯从 0 到 1 建设 BI 可视化项目时，光是技术选型，就做了好几周，从多个角度深入且综合地对比了国内外主流的数据存储技术。

既然技术选型可能花费这么多的时间精力，那我们为什么还要做技术选型呢？



## 三、为什么要做技术选型？

相信很多还未工作过的朋友，是从来没有系统地做过技术选型的。

这很正常，因为大家在学习阶段，都是跟着网上的教程做项目，用什么技术、用哪个版本、甚至写什么代码，全部都是讲师给你提前规划好的。

![](https://pic.yupi.icu/1/image-20230331134500590-20230706153049690-20230706153117049-20230706163222417.png)

但其实，并不是没有做技术选型，而是讲师帮你做了而已。讲师选择用什么技术带你做项目时，本质上也是在做技术选型，会结合市场需求、技术流行度等多方面因素。

那么为什么要做技术选型呢？

答案很简单，为了 **更好** 地开发和维护项目。

这里的 “更好” 可能是提高效率、节约成本、提升开发体验、提高项目可扩展性等。

想象一下，当我们在企业中团队开发项目时，如果领导（或架构师）为了省事儿，选择了一个只有他自己熟悉、其他成员却完全不会用的技术，整个项目的开发进度会快么？如果为了贪图小便宜，选择了一个低成本、做工粗糙的云数据库，整个项目的性能会高么？

在开发一个 **完整项目** 前，如果我们不假思索，直接确定某个技术就开始写代码，那么有可能等到后面，才突然出现翻车。就好像鱼皮给自己的电动车选了个便宜的轮胎，刚开始也能正常地跑，结果有天半路爆胎了，只能傻傻地原地等待。。。

举个我自己大学时期的翻车经历。大学我带团队做过一个校园贴吧网站，记得我是用 React  来开发前端页面的。刚开始很顺利，一口气写了几十个页面；但直到有一天需要开发帖子页面信息状态保存功能的时候，才发现 React 不像 Vue Router 一样有现成的 keep-alive（缓存组件状态）。后来又花了好久才找到一个类似的组件，结果还一堆 Bug！

而且，越是对项目代码侵入性强的技术（比如开发框架），后期的切换成本就越大。像我上面举的翻车例子，等页面都写了几十个了，再去切换开发框架，就会非常麻烦；而且有的时候，你给项目引入新的组件或类库，可能会和现有的依赖版本冲突，导致后面项目跑不起来。这个时候，你是选择切换老的技术、还是再花更大的精力去找和老技术不冲突的新技术呢？更有甚者，为了兼容项目原本用到的老到不行的技术框架，不敢引入任何的新技术，导致什么都自己开发。。。可谓一步错，步步错！

这些其实都是未做技术选型、或者技术选型不当带来的问题，也印证了我们做技术选型的必要性。

现在看来，确实是当时经验不足。如果我在最开始就能考虑到这点，先全局确认实现项目功能可能会用到的技术，并且选择合适的技术，就能减少后期风险、节省很多时间了。



## 四、如何做好技术选型？

在了解技术选型的重要性后，我们来聊聊如何做好技术选型。

接下来，我会结合自己团队的技术选型经验，从几个方面带大家掌握技术选型的要点。



### 4.1、明确上下文

首先要明确一点：没有绝对完美的技术，我们做技术选型的目标是在 **有限的条件** 下、选取 **特定场景** 下的技术 **最优解** 。

几个关键词：



#### 1）有限条件

指团队的人数、人员的技能、时间成本、金钱成本等。

比如大家都只会 Java、项目又急着上线，那肯定优先选择 Java 相关技术栈，不要因为听说 Go 语言的性能高，就让大家加班去学 Go。

比如公司缺资金、没资源，那么相较于选择付费的服务（比如云数据库），不妨直接在一台服务器上自主搭建。

再比如公司资源很多，但是缺人力，那么像数据库等服务就不用自己搭建了，直接买第三方的云服务即可。

比较常见的选型方案是先从人力的角度出发，看看团队的同学都会哪些技术。如果需求很紧急的话，那肯定优先选择大家用的比较熟的技术，先完成一期需求快速交付，后面再调研更合适的技术架构，不断地优化。再比如团队内对于某个技术有比较成熟的实践经历和知识沉淀、也有相应的技术大佬，那么可以优先选用该技术。举个最典型的例子，阿里的研发团队优先选用 Java、字节优先选 Go。

再从资源的角度考虑，要看团队的资源是否适合运用这个技术。比如创业小团队，没什么资金，那么可以用 MySQL 代替 Elasticsearch 来实现搜索功能，牺牲灵活性来省钱。再比如公司只能提供 4G 内存的服务器，那在选用一些开源技术的时候就要关注它们的内存占用，不能超过这个阈值。



#### 2）特定场景

是指我们的技术选型一定要围绕着 **特定的业务和需求** 来做，贴合实际，而不是为了用技术而用技术。

可以思考以下几个问题：

1. 你要实现哪些功能？比如要做一个网盘系统，就要重点选型文件存储技术；要做一个聊天室系统，就要重点选择实时通信技术。
2. 你的业务量级有多大？如果用户数量多、数据存储量大，可以选用分布式数据库、或者分库分表；如果同时使用系统的用户数多（并发量大），可以选用 Nginx 或者 LVS 来实现负载均衡。
3. 系统的核心业务流程及关键数据结构是什么？比如要做一个管理系统，那么数据库选择主流的关系型数据库 MySQL 就好；而如果要做数据分析系统，那么应该选择 OLAP 型数据库，比如 ClickHouse 等。
4. 系统更注重哪些性能指标？比如日志收集的场景更注重高性能和吞吐量，那么可以选择 Kafka 消息队列来采集；比如注重低延迟以及消息的准确性，那么可以选择 RabbitMQ。



有限条件 + 特定场景 = 上下文，也可以理解为团队、项目的实际情况。



#### 3）最优解

很多时候，我们做技术选型和设计算法一样，没有绝对的最优解，而是对时间、空间、稳定性、可用性、性能等等的综合权衡。

不同的上下文，选取的最优解也不同。这才是技术选型最有意思、同时也是最折磨人的地方！

> CAP 理论也是如此，它是指在一个分布式系统中，无法同时满足一致性（Consistency）、可用性（Availability）和分区容错性（Partition Tolerance）这三个特性，只能根据实际情况在三者间进行权衡。



### 4.2、充分调研

在明确了我们团队和项目的实际情况后，我们要进行充分的调研。可以利用某度、某歌、GitHub 等各搜索引擎，或者文章和视频等等来探寻可能要用到的各类技术的信息。

包括：

- 这个技术是什么？有什么用？
- 这个技术有什么优点和不足？
- 这个技术的使用成本如何？
- 这个技术更适用于什么场景？
- 这个技术的背景和口碑等等



有很多网站，也可以帮助我们获取技术选型信息，比如：

- 技术雷达：https://www.thoughtworks.com/zh-cn/radar
- 框架性能对比：[https://www.techempower.com/benchmarks](https://www.techempower.com/benchmarks/#section=data-r21)



不过我很久没用过这些网站了，自从人工智能对话技术流行后，我在做技术选型时，会直接去问 AI（GPT 或鱼聪明），让它帮我获取信息。

比如问它：你是一位计算机编程领域的专家，现在我要做一个 XX 系统，大致有 XX 功能，限定条件为 XX。请帮我列举实现这些所需的技术，要求多推荐一些同类技术并列举每个技术的介绍、优缺点和适用场景，便于我评估实现该系统的技术选型最优解。



注意，在调研阶段，大家应该先尽可能多地搜索相关技术，而不要把视野局限于某个技术。

建议把调研到的所有技术信息以表格或清单的形式记录在文档中，持续完善和补充，便于对比和最终选择技术。

就像下面这样：

![](https://pic.yupi.icu/1/image-20230706180955933.png)

在大公司大项目中，技术选型一定要提供充分的依据和理由，才会得到上级或其他成员的认可。



### 4.3、对比选择

收集到足够多的信息后，我们就可以根据上下文 + 收集到的信息来综合选择最合适的技术。

除了上下文之外，建议大家优先选择：知名度高的、有大公司背书的、持续维护的、活跃度高的、开源的、文档齐全的、用户多生态好的技术。

比如大名鼎鼎的前端框架 Vue 和 Java 后端框架 Spring Boot，大家对它们的印象就是功能强大、简单好用、学习资源多，所以这两个技术是主流，公司需求量也大。

千万不要选择缺失文档的、没几个人用的冷门技术！一旦后面出了问题，网上又找不到解决方案，说不定整个项目都无法继续推进！



### 4.4、最简 Demo 验证

在最终确认要选择的技术前，不要忘了验证一下该技术是否能够运用到咱们的项目中，而不是直接拍板！

推荐的做法是编写一个最简 Demo 来快速验证技术是否可用。比如使用 Vue Router 页面路由技术，那就编写一个点击按钮，快速跳转到 `/about` 页面的 Demo。

这个过程，本质上就是实现了理论到实践落地的过渡。

也是感谢人工智能技术的发展，现在想编写 Demo 快速验证，都不用自己写代码了，直接问 GPT 即可：

![](https://pic.yupi.icu/1/image-20230706182008022.png)



如果我们的系统是老项目，需要重点关注新引入的技术和老项目依赖的兼容性。这个时候，编写最简 Demo 验证是非常有必要的，可以提前规避版本冲突。



### 4.5、日常积累

除了上面这些方法外，想做好技术选型，经验值的积累也是很重要的。比如某个电商领域的十年架构师，要做一个新的电商系统，立刻就能想到合适的技术选型、甚至是整个系统的完整实现方案。

给大家两个建议：

1）持续记录

把自己看到的 **每个** 和你学习方向或工作相关的技术都先记录到文档中，有时间的时候可以快速了解该技术的大致信息，知道这个技术是做什么的、有什么用。等需要用到的时候能想起来、或者能从文档中搜索到即可。

2）拓宽边界

不要幻想用一门技术吃遍天，也不要满足于自己的技术领域。尤其是在自学阶段、做一些小项目时，可以偶尔尝试使用一些平时不接触的新技术，横向拓宽自己的技术选型范围。

比如虽然我的工作是 Java 后端，但经常会做一些前端项目，而且每次都换着用技术，比如 Vue、React、Svelte 等。



## 五、技术选型实践

介绍完方法论，最后再分享下我们团队关于鱼聪明 AI 的技术选型实践。

按照上面分享的几个步骤，首先是明确上下文。



### 5.1、明确上下文

#### 1）有限条件

我们团队人力少，大家最熟悉的技术框架是后端 Java Spring Boot + 前端 React，所以前后端的技术框架基本确定。

也没有足够的资金去购买很多服务器和第三方服务，所以对大多数非核心服务，使用 Java Tomcat 单机部署，并且使用宝塔 Linux 进行服务器管理。



#### 2）特定场景

4 问 4 答：

1. 你要实现哪些功能？我们要实现的 P0 级核心功能有：AI 对话、AI 助手、内容审核。AI 对话和内容审核都可以使用第三方 GPT 服务实现。
2. 你的业务量级有多大？网站初期，用户的并发量不会很大，暂定 qps（每秒请求数）不超过 3，目前还不需要用到负载均衡技术。
3. 系统的核心业务流程及关键数据结构是什么？核心业务流程是用户发送对话 => AI 自动回复 => 存储消息记录。那么就涉及了对话和消息记录的保存，由于一个对话可以包含多个消息记录，所以很适合选用关系型数据库 MySQL 来实现。
4. 系统更注重哪些性能指标？由于自己之前网站经常被攻击，所以这次非常注重系统的安全性和可用性。为了控制并发，可以选用 Redis + Redisson 实现分布式限流，控制每个用户发送消息的频率不能过于频繁。



#### 3）最优解

这里就举一个例子吧：是消耗成本使用第三方的云数据库服务，还是自己在服务器上搭建数据库呢？

还在学校的时候，我肯定会选择后者。因为很多项目就是自己学习练手用的，能跑就行；自己搭建数据库本身也能帮我熟悉 Linux 服务器的命令。当然最关键的还是省米，省下来给自己午餐加个鸡腿它不香么？

但现在要做面向用户的线上项目了，我就会更倾向于使用现成的云数据库服务，数据库的搭建、运维、管理、调优别人都给你做好了，你拿到数据库账号密码就能直接用，还不用担心数据库宕机。相比于多投入的一些资金，能大幅节省我们 “本就不富裕” 的开发和运维成本。

这是我们当下对于数据库技术选型的最优解。



### 5.2、充分调研

上文也提到了，我们系统的 **绝大多数功能** 都使用主流技术 Spring Boot + React 实现，它们都属于我们团队人员的看家本领、也都是生态好的知名技术，不必做更多的调研。

相反，我们投入了比较多的时间在 **内容审核** 这个小功能的调研上。

为什么？

因为对 AIGC 类产品，内容审核是至关重要的；而更关键的是，内容审核要成本啊！

为了兼顾内容审核的质量和成本，我们把目光锁定到了国内的几家大厂提供的云服务上，也就是 BAT。

并且通过阅读官方文档和客服询问的方式，整理出了如下的对比表格：

> 数据仅为示例参考，请以官方为准

![](https://pic.yupi.icu/1/image-20230706195734818.png)



### 5.3、对比选择

有了上图的对比表格，我们就可以结合实际的业务情况来选择使用哪种内容审核技术了。

比如我们的对话功能中，允许用户单次输入的最大字符数为 1000 - 2000 左右，对话功能的使用 QPS 不超过 10，那么选择服务商 A 或 B 都是合理的。

> 我们可以将用户的单次输入拆分为多个段落，通过发多次请求来绕过字符数限制。



### 5.4、最简 demo 验证

确定了要使用的技术后，剩下的工作就很简单了。对于第三方提供的内容审核云服务，我们只需打开官方文档，就能找到现成的示例代码，下载到本地执行成功即可。

![](https://pic.yupi.icu/1/image-20230706200934291.png)



### 5.5、日常积累

最后，关于日常积累，其实在上一篇文章《文档沉淀》时有提到。我们团队每天都在持续关注 AI 相关的技术动向，只要发现有了新的技术，会立刻记录在我们团队的公共知识库中。需要用到这个技术的时候，再进一步研究。



---




技术选型是做好产品的重要一环。选对了技术，可以事半功倍；选错了技术，可能会让项目陷入困境。

记住这几个关键点：

1. 技术选型要结合团队实际情况和项目需求
2. 要充分调研，多方对比
3. 优先选择知名度高、生态好的技术
4. 要编写最简 Demo 验证可行性
5. 要持续积累技术选型的经验

在 Vibe Coding 时代，AI 可以帮你快速了解各种技术，甚至帮你生成 Demo 代码。但是，如何根据实际情况选择最合适的技术，仍然需要你自己的判断和积累。

加油，选对技术，让你的产品开发更顺利！💪


## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
